/*!
 * @file Vector.h
 * @brief xNgNX`wb_
 * @author cherub
 * @date 2005.09.16
*/

#ifndef MK_VECTOR_GSL_HEADER_
#define MK_VECTOR_GSL_HEADER_
#pragma once

#include <gsl/gsl_vector.h>

class CMatrix;

/*!
 * @class CVectorNX Vector.h
 * @brief GSLxNg֐Q̃bp[NX
 * @author cherub
 * @date 2005.09.16
*/
class CVector
{
public:
	// ftHgRXgN^
	CVector(void);
	// Rs[RXgN^
	CVector(const CVector &v);
	//	TCYwRXgN^
	CVector(size_t unSize);
	// qTCYwRXgN^
	CVector(size_t unSize, double dInit);
	//	fXgN^
	~CVector(void);

public:
	// ֐
	void Initialize(size_t unSize, double dInit =0.0);
	// xNg̃[NA
	void ZeroClear();
	//	CӒlɂxNgNA
	void Clear(double dInit);
	//	IuWFNg̔j
	void Destroy(void);

public:
	// xNg̎擾
	size_t Size(void) const;
	//! f[^ANZX֐
	double& Data(size_t p)
		{
			return *gsl_vector_ptr(m_pvVector, p);
		}
	//! f[^ANZX֐(const^)
	const double& Data(size_t p) const
		{
			return *gsl_vector_const_ptr(m_pvVector, p);
		}
	//! f[^ANZXZq
	double& operator [] (size_t p)
		{
			return Data(p);
		}
	//! f[^ANZXZq(const)
	const double& operator [] (size_t p) const
		{
			return Data(p);
		}

public:
	// xNg̈v
	bool operator == (const CVector &v) const;
	//! xNg̕sv
	bool operator != (const CVector &v) const
		{
			return !(operator ==(v));
		}
	// xNg̑Svf̕𔽓]
	//CVector operator - (void) const;
	// Zq
	CVector& operator = (const CVector &v);
	// ZZq
	CVector operator + (const CVector &v) const;
	// ZZq
	CVector operator - (const CVector &v) const;
	// XJZZq
	CVector operator + (double d) const;
	// XJZZq
	CVector operator * (double d) const;

	// ZZq
	CVector& operator += (const CVector &v);
	// ZZq
	CVector& operator -= (const CVector &v);
	// XJZZq
	CVector& operator += (double d);
	// XJZZq
	CVector& operator *= (double d);

	// sƂ̏ZZq
	CVector operator * (const CMatrix &m) const;

public:
	// ŏl̎擾
	double MinElement(void) const;
	// ől̎擾
	double MaxElement(void) const;
	// ŏlEől̎擾
	void MinMaxElement(double &dMin, double &dMax) const;
	// ŏlCfNX̎擾
	size_t MinIndex(void) const;
	// őlCfNX̎擾
	size_t MaxIndex(void) const;
	// ŏlEőlCfNX̎擾
	void MinMaxIndex(size_t &unMin, size_t &unMax) const;

public:
	// evfꂼ̐
	CVector ElementsProduct(const CVector &v) const;

	// ς̌vZ
	// ex) a^T * a
	double Dot(const CVector &v) const;
	
	// xNgm̐ςōsɂȂꍇɗp
	// ex) a * a^T
	CMatrix Dot2(const CVector &v) const;

	// 2̃m()̌vZ
	double Norm(void) const;

	// Svf̐Βl̘ǎvZ
	double SelfSumAbs(void) const;

	//! xNggp\`FbN
	bool IsActive(void)
		{
			return (m_pvVector != NULL);
		}
public:
	//! GSLxNgIuWFNg
	gsl_vector *m_pvVector;
};

#endif // MK_VECTOR_GSL_HEADER_
